The code contained in this folder was used to run the variance simulations of Section 3 and the experiments in Section 5.

Variance Simulations
- VarianceSimsTools.py provides the code for the three competing variance estimators, the Separate Arm Estimator (Alt_est), the Uniform Estimator (White_Estimator) and HEAD (two_spaces). Additionally, Franke Wolfe optimization is implemented to find the G-optimal designs, the "static" versions of the algorithms were created to speed up the simulations and two forms of arm space sampling are included (two_spheres_samp is the sampling paradigm for the simulations in the paper).
- VarianceSimsRun.py runs the variance simulations in parallel using the run_sample_sim function from VarianceSimsTools.py.

Best-arm Identification Simulations
- identifiable.py contains the function MVT_arms_identif, which constructs the arms for the multivariate testing experiment.
- experimental_design.py has two methods of performing Franke Wolfe optimization. get_XYdesign is specifically for XY-Allocation while FrankWolfe_XY is more general. get_oracle finds the oracle allocations.
- VarianceSimsTools_BAI.py includes the variance estimation functions used in algorithms.py
- algorithms.py contains AdaptiveXY, which is a master function for calling H-RAGE (Alg. 2) and RAGE (Alg. 5).
- BAISims.py constructs each of the experimental settings in Section 5 and then runs H-RAGE (Alg. 2) and RAGE (Alg. 5) as well as the Homoskedastic and Heteroskedastic Oracles. 
- RunBAISims.py is the driver for BAISims.py